/*
 * Decompiled with CFR 0.152.
 */
package btchat;

import btchat.ChatMain;
import btchat.ChatPacket;
import btchat.EndPoint;
import java.io.DataInputStream;

public class Reader
implements Runnable {
    public EndPoint endpt;
    private boolean done = false;

    public void stop() {
        this.done = true;
    }

    public void run() {
        try {
            DataInputStream dataInputStream = this.endpt.con.openDataInputStream();
            while (!this.done) {
                String string;
                Reader.log("waiting for next signal from " + this.endpt.remoteName);
                int n = dataInputStream.readInt();
                if (n == 1) {
                    string = dataInputStream.readUTF();
                    ChatPacket chatPacket = new ChatPacket(1, this.endpt.remoteName, string);
                    Reader.log("read in MESSAGE string '" + string + "' from " + this.endpt.remoteName);
                    this.endpt.callback.handleAction("received", this.endpt, chatPacket);
                    continue;
                }
                if (n == 0) {
                    string = dataInputStream.readUTF();
                    Reader.log("read in HANDSHAKE name " + string + " from " + this.endpt.remoteName);
                    this.endpt.remoteName = string;
                    this.endpt.putString(4, this.endpt.localName);
                    this.endpt.callback.handleAction("join", this.endpt, null);
                    continue;
                }
                if (n == 3) {
                    Reader.log("read in TERMINATE from " + this.endpt.remoteName);
                    this.endpt.putString(5, "end");
                    this.endpt.callback.handleAction("leave", this.endpt, null);
                    this.endpt.btnet.cleanupRemoteEndPoint(this.endpt);
                    this.stop();
                    continue;
                }
                if (n == 4) {
                    string = dataInputStream.readUTF();
                    Reader.log("read in  HANDSHAKE_ACK name " + string + " from " + this.endpt.remoteName);
                    this.endpt.remoteName = string;
                    continue;
                }
                if (n == 5) {
                    System.out.println("read in TERMINATE_ACK from " + this.endpt.remoteName);
                    continue;
                }
                Reader.log("Unkonwn signal, probably connection closed");
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Reader.log(exception.getClass().getName() + " " + exception.getMessage());
        }
        Reader.log("reader thread exit for " + this.endpt.remoteName);
    }

    private static void log(String string) {
        System.out.println("Reader: " + string);
        if (ChatMain.isDebug) {
            ChatMain.gui_log("R", string);
        }
    }
}

