/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class Plot
extends Form
implements CommandListener,
Runnable {
    Calculator calculator;
    Gauge progressIndicator;
    StringItem completed;
    Float from;
    Float till;
    Float x;
    Float dx;
    Float[] values;
    int i;
    int percent;
    Thread thread;
    boolean running;
    Compiler.FunctionExpression f;
    static Float screenWidth = new Float(new DummyCanvas().getWidth() - 1);

    Plot(Calculator calculator, Compiler.PlotExpression plotExpression) {
        super("Plot");
        this.calculator = calculator;
        this.from = plotExpression.from.evaluate(calculator.bindings);
        this.till = plotExpression.till.evaluate(calculator.bindings);
        this.dx = plotExpression.step != null ? plotExpression.step.evaluate(calculator.bindings) : this.till.Sub(this.from).Div(screenWidth);
        this.f = plotExpression.f;
        int n = (int)this.till.Sub(this.from).Div(this.dx).toLong() + 1;
        if (n < 2) {
            calculator.showAlert(AlertType.ERROR, "Error", "Bad interval");
            return;
        }
        this.values = new Float[n];
        this.i = 0;
        this.x = this.from;
        this.progressIndicator = new Gauge("Progress indicator", false, n, 0);
        this.completed = new StringItem("Completed:", "0%");
        this.append((Item)this.progressIndicator);
        this.append((Item)this.completed);
        this.setCommandListener(this);
        this.addCommand(Calculator.STOP_CMD);
        Display.getDisplay((MIDlet)calculator).setCurrent((Displayable)this);
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        int n = this.values.length;
        try {
            while (this.running && this.i < n) {
                this.f.arguments[0] = this.x;
                this.values[this.i] = this.f.evaluate(this.calculator.bindings);
                int n2 = this.i * 100 / n;
                if (n2 != this.percent) {
                    this.progressIndicator.setValue(this.i);
                    this.percent = n2;
                    this.completed.setText(Integer.toString(n2) + '%');
                }
                this.x = this.x.Add(this.dx);
                ++this.i;
            }
        }
        catch (CompileError compileError) {
            this.calculator.showAlert(AlertType.ERROR, "Error", compileError.getMessage());
            return;
        }
        if (this.i == n) {
            new Graph(this.calculator, this.from, this.till, this.values);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Calculator.STOP_CMD) {
            this.running = false;
            Display.getDisplay((MIDlet)this.calculator).setCurrent((Displayable)this.calculator.mainMenu);
        }
    }

    static class DummyCanvas
    extends Canvas {
        DummyCanvas() {
        }

        protected void paint(Graphics graphics) {
        }
    }
}

