/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class Calculator
extends MIDlet
implements CommandListener {
    TextBox mainMenu;
    static Command QUIT_CMD = new Command("Quit", 2, 4);
    static Command STOP_CMD = new Command("Stop", 2, 1);
    static Command BACK_CMD = new Command("Back", 2, 4);
    static Command DONE_CMD = new Command("Done", 8, 1);
    static Command EVAL_CMD = new Command("Evaluate", 8, 1);
    static Command DELETE_CMD = new Command("Delete", 8, 2);
    static Command LIST_CMD = new Command("List", 8, 2);
    static Command EDIT_CMD = new Command("Edit", 8, 1);
    static Command NEW_CMD = new Command("New", 8, 3);
    static Command INS_CMD = new Command("Insert", 8, 2);
    static Command HELP_CMD = new Command("Help", 8, 2);
    static final String TITLE = "Calculator";
    static final int MAX_LENGTH = 256;
    static final String ENCODING = "UTF-8";
    RecordStore store;
    Hashtable bindings = new Hashtable();
    Vector statements = new Vector();
    Statement stmt;

    private void openStore() {
        try {
            this.store = RecordStore.openRecordStore((String)"CALCULATOR", (boolean)true);
            int n = this.store.getNextRecordID();
            for (int i = 1; i < n; ++i) {
                byte[] byArray = null;
                try {
                    byArray = this.store.getRecord(i);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
                if (byArray == null) continue;
                Statement statement = new Statement(i, byArray);
                try {
                    Compiler compiler = new Compiler(statement.text);
                    Compiler.Expression expression = compiler.compile();
                    if (expression instanceof Compiler.Declaration) {
                        ((Compiler.Declaration)((Object)expression)).declare(this.bindings);
                    }
                    statement.state = 1;
                }
                catch (CompileError compileError) {
                    statement.state = 2;
                }
                this.statements.addElement(statement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeStatement(int n) {
        Statement statement = (Statement)this.statements.elementAt(n);
        if (this.stmt.id != 0) {
            try {
                this.store.deleteRecord(statement.id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.statements.removeElementAt(n);
        if (this.statements.size() != 0) {
            this.stmt = (Statement)this.statements.lastElement();
        } else {
            this.stmt = new Statement("");
            this.statements.addElement(this.stmt);
        }
        this.mainMenu.setString(this.stmt.text);
    }

    void editStatement(int n) {
        this.stmt = (Statement)this.statements.elementAt(n);
        this.mainMenu.setString(this.stmt.text);
    }

    void storeStatement() {
        this.stmt.text = this.mainMenu.getString();
        byte[] byArray = this.stmt.pack();
        try {
            if (this.stmt.id == 0) {
                this.stmt.id = this.store.addRecord(byArray, 0, byArray.length);
            } else {
                this.store.setRecord(this.stmt.id, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeStore() {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
                this.store = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Calculator() {
        this.openStore();
        if (this.statements.size() == 0) {
            this.stmt = new Statement("");
            this.statements.addElement(this.stmt);
        } else {
            this.stmt = (Statement)this.statements.lastElement();
        }
        this.mainMenu = new TextBox(TITLE, this.stmt.text, 256, 0);
        this.mainMenu.addCommand(QUIT_CMD);
        this.mainMenu.addCommand(EVAL_CMD);
        this.mainMenu.addCommand(HELP_CMD);
        this.mainMenu.addCommand(NEW_CMD);
        this.mainMenu.addCommand(LIST_CMD);
        this.mainMenu.addCommand(DELETE_CMD);
    }

    protected void destroyApp(boolean bl) {
        this.storeStatement();
        this.closeStore();
        this.mainMenu = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    void showAlert(AlertType alertType, String string, String string2) {
        Alert alert = new Alert(string, string2, null, alertType);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.mainMenu);
    }

    void newStatement() {
        this.stmt = new Statement("");
        this.statements.addElement(this.stmt);
        this.mainMenu.setString("");
    }

    void insertText(String string) {
        this.mainMenu.insert(string, this.mainMenu.getCaretPosition());
    }

    void quit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.quit();
        } else if (command == LIST_CMD) {
            this.storeStatement();
            new StatementList(this);
        } else if (command == HELP_CMD) {
            new HelpList(this);
        } else if (command == DELETE_CMD) {
            this.stmt.text = "";
            this.mainMenu.setString("");
        } else if (command == NEW_CMD) {
            this.storeStatement();
            this.newStatement();
        } else if (command == EVAL_CMD) {
            this.storeStatement();
            if (this.stmt.text.trim().length() != 0) {
                try {
                    Compiler compiler = new Compiler(this.stmt.text);
                    Compiler.Expression expression = compiler.compile();
                    this.stmt.state = 1;
                    try {
                        Float float_ = expression.evaluate(this.bindings);
                        if (expression instanceof Compiler.PlotExpression) {
                            new Plot(this, (Compiler.PlotExpression)expression);
                        } else if (float_ != null) {
                            new ResultView(this, this.stmt.text, float_.toString());
                        }
                    }
                    catch (CompileError compileError) {
                        this.showAlert(AlertType.ERROR, "Runtime error", compileError.getMessage());
                    }
                }
                catch (CompileError compileError) {
                    this.stmt.state = 2;
                    this.showAlert(AlertType.ERROR, "Compile error", compileError.getMessage());
                }
            }
        }
    }

    static class Statement {
        String text;
        int id;
        int state;
        static final int UNKNOWN = 0;
        static final int COMPILED = 1;
        static final int ERROR = 2;

        byte[] pack() {
            try {
                return this.text.getBytes(Calculator.ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return this.text.getBytes();
            }
        }

        Statement(String string) {
            this.text = string;
        }

        Statement(int n, byte[] byArray) {
            this.id = n;
            try {
                this.text = new String(byArray, Calculator.ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.text = new String(byArray);
            }
        }
    }
}

