/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;

public class Compiler {
    static final int SIN = 0;
    static final int COS = 1;
    static final int TAN = 2;
    static final int ASIN = 3;
    static final int ACOS = 4;
    static final int ATAN = 5;
    static final int EXP = 6;
    static final int LOG = 7;
    static final int ABS = 8;
    static final int CEIL = 9;
    static final int FLOOR = 10;
    static final int INT = 11;
    static final int FRAC = 12;
    static final int SQR = 13;
    static Hashtable builtin = new Hashtable();
    FunctionExpression function;
    String[] parameters;
    Float value;
    String str;
    String name;
    int pos;
    int tkn;

    public Compiler(String string) {
        this.str = string;
    }

    public Expression compile() {
        Expression expression = this.compileExpression();
        if (this.tkn != -1) {
            throw new CompileError("Unexpected token '" + (char)this.tkn + "'");
        }
        return expression;
    }

    private Expression compileExpression() {
        Expression expression = this.compileAssignmentExpression();
        if (this.tkn == 44) {
            Vector<Expression> vector = new Vector<Expression>();
            vector.addElement(expression);
            do {
                vector.addElement(this.compileAssignmentExpression());
            } while (this.tkn == 44);
            Expression[] expressionArray = new Expression[vector.size()];
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = (Expression)vector.elementAt(i);
            }
            expression = new ExpressionList(expressionArray);
        }
        return expression;
    }

    private Expression compileAssignmentExpression() {
        Expression expression = this.compileCondExpression();
        if (this.tkn == 61) {
            if (expression instanceof VariableExpression) {
                AssignmentExpression assignmentExpression = new AssignmentExpression();
                assignmentExpression.name = ((VariableExpression)expression).name;
                assignmentExpression.expr = this.compileExpression();
                return assignmentExpression;
            }
            if (expression instanceof FunctionCallExpression) {
                FunctionCallExpression functionCallExpression = (FunctionCallExpression)expression;
                FunctionExpression functionExpression = this.function;
                String[] stringArray = this.parameters;
                this.parameters = new String[functionCallExpression.parameters.length];
                for (int i = 0; i < this.parameters.length; ++i) {
                    if (!(functionCallExpression.parameters[i] instanceof VariableExpression)) {
                        throw new CompileError("Invalid function parameter");
                    }
                    this.parameters[i] = ((VariableExpression)functionCallExpression.parameters[i]).name;
                }
                this.function = new FunctionExpression();
                this.function.arguments = new Float[this.parameters.length];
                this.function.body = this.compileExpression();
                FunctionDefExpression functionDefExpression = new FunctionDefExpression();
                functionDefExpression.name = functionCallExpression.name;
                functionDefExpression.func = this.function;
                this.function = functionExpression;
                this.parameters = stringArray;
                return functionDefExpression;
            }
            throw new CompileError("Assignment can be done to variable or function");
        }
        return expression;
    }

    private Expression compileCondExpression() {
        Expression expression = this.compileCmpExpression();
        while (this.tkn == 63) {
            ConditionalExpression conditionalExpression = new ConditionalExpression();
            conditionalExpression.cond = expression;
            conditionalExpression.ifTrue = this.compileCmpExpression();
            if (this.tkn != 58) {
                throw new CompileError("':' expected");
            }
            conditionalExpression.ifFalse = this.compileCmpExpression();
            expression = conditionalExpression;
        }
        return expression;
    }

    private Expression compileCmpExpression() {
        Expression expression = this.compileAddExpression();
        int n = this.tkn;
        if (n == 62 || n == 60) {
            Expression expression2 = this.compileAddExpression();
            if (n == this.tkn) {
                RangeExpression rangeExpression = new RangeExpression();
                if (n == 60) {
                    rangeExpression.min = expression;
                    rangeExpression.expr = expression2;
                    rangeExpression.max = this.compileAddExpression();
                } else {
                    rangeExpression.max = expression;
                    rangeExpression.expr = expression2;
                    rangeExpression.min = this.compileAddExpression();
                }
                return rangeExpression;
            }
            BinaryExpression binaryExpression = n == 60 ? new LessExpression() : new GreatExpression();
            binaryExpression.left = expression;
            binaryExpression.right = expression2;
            return binaryExpression;
        }
        return expression;
    }

    private Expression compileAddExpression() {
        Expression expression = this.compileMulExpression();
        int n = this.tkn;
        while (n == 43 || n == 45) {
            Expression expression2 = this.compileMulExpression();
            BinaryExpression binaryExpression = n == 43 ? new AddExpression() : new SubExpression();
            binaryExpression.left = expression;
            binaryExpression.right = expression2;
            expression = binaryExpression;
            n = this.tkn;
        }
        return expression;
    }

    private Expression compileMulExpression() {
        Expression expression = this.compilePowerExpression();
        int n = this.tkn;
        while (n == 42 || n == 47) {
            Expression expression2 = this.compilePowerExpression();
            BinaryExpression binaryExpression = n == 42 ? new MulExpression() : new DivExpression();
            binaryExpression.left = expression;
            binaryExpression.right = expression2;
            expression = binaryExpression;
            n = this.tkn;
        }
        return expression;
    }

    private Expression compilePowerExpression() {
        Expression expression = this.compileUnaryExpression();
        if (this.tkn == 94) {
            Expression expression2 = this.compilePowerExpression();
            PowerExpression powerExpression = new PowerExpression();
            powerExpression.left = expression;
            powerExpression.right = expression2;
            return powerExpression;
        }
        return expression;
    }

    private Expression compileUnaryExpression() {
        Expression expression;
        switch (this.scan()) {
            case 43: {
                return this.compileUnaryExpression();
            }
            case 45: {
                return new NegExpression(this.compileUnaryExpression());
            }
            case 48: {
                expression = new LiteralExpression(this.value);
                break;
            }
            case 40: {
                expression = this.compileExpression();
                if (this.tkn == 41) break;
                throw new CompileError("')' expected");
            }
            case 91: {
                expression = this.compileExpression();
                if (this.tkn != 93) {
                    throw new CompileError("']' expected");
                }
                expression = new BuiltinFunction(11, expression);
                break;
            }
            case 123: {
                expression = this.compileExpression();
                if (this.tkn != 125) {
                    throw new CompileError("'}' expected");
                }
                expression = new BuiltinFunction(12, expression);
                break;
            }
            case 124: {
                expression = this.compileExpression();
                if (this.tkn != 124) {
                    throw new CompileError("'|' expected");
                }
                expression = new BuiltinFunction(8, expression);
                break;
            }
            case 97: {
                if (this.name.equals("pi")) {
                    expression = new LiteralExpression(Float.PI);
                    break;
                }
                if (this.name.equals("e")) {
                    expression = new LiteralExpression(Float.E);
                    break;
                }
                if (this.function != null) {
                    for (int i = 0; i < this.parameters.length; ++i) {
                        if (!this.parameters[i].equals(this.name)) continue;
                        this.tkn = this.scan();
                        return new ParameterExpression(i, this.function);
                    }
                }
                String string = this.name;
                this.tkn = this.scan();
                if (this.tkn == 40) {
                    expression = this.compileExpression();
                    if (this.tkn != 41) {
                        throw new CompileError("')' expected");
                    }
                    Expression[] expressionArray = expression instanceof ExpressionList ? ((ExpressionList)expression).exprs : new Expression[]{expression};
                    if (string.equals("plot")) {
                        Expression expression2;
                        if (expressionArray.length < 3) {
                            throw new CompileError("Plot function expect three or four parameters");
                        }
                        PlotExpression plotExpression = new PlotExpression();
                        plotExpression.from = expressionArray[0];
                        plotExpression.till = expressionArray[1];
                        if (expressionArray.length == 4) {
                            plotExpression.step = expressionArray[2];
                            expression2 = expressionArray[3];
                        } else {
                            expression2 = expressionArray[2];
                            plotExpression.step = null;
                        }
                        if (!(expression2 instanceof VariableExpression)) {
                            throw new CompileError("Last parameter of plot should be function");
                        }
                        plotExpression.func = ((VariableExpression)expression2).name;
                        expression = plotExpression;
                        break;
                    }
                    Integer n = (Integer)builtin.get(string);
                    if (n != null) {
                        if (expressionArray.length != 1) {
                            throw new CompileError("Function " + string + " has one parameter");
                        }
                        expression = new BuiltinFunction(n, expressionArray[0]);
                        break;
                    }
                    FunctionCallExpression functionCallExpression = new FunctionCallExpression();
                    functionCallExpression.name = string;
                    functionCallExpression.parameters = expressionArray;
                    expression = functionCallExpression;
                    break;
                }
                return new VariableExpression(string);
            }
            default: {
                throw new CompileError("Syntax error");
            }
        }
        this.tkn = this.scan();
        return expression;
    }

    int scan() {
        int n;
        char c = '\u0000';
        int n2 = this.str.length();
        for (n = this.pos; n < n2 && ((c = this.str.charAt(n)) == ' ' || c == '\n'); ++n) {
        }
        this.pos = n;
        if (n == n2) {
            return -1;
        }
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
            while (++n < n2 && (c = this.str.charAt(n)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
            }
            this.name = this.str.substring(this.pos, n).toLowerCase();
            this.pos = n;
            return 97;
        }
        if (c >= '0' && c <= '9') {
            while (++n < n2 && (c = this.str.charAt(n)) >= '0' && c <= '9') {
            }
            if (c == '.') {
                while (++n < n2 && (c = this.str.charAt(n)) >= '0' && c <= '9') {
                }
            }
            if (c == 'e' || c == 'E') {
                if (n + 1 < n2 && (c = this.str.charAt(n + 1)) == '+' || c == '-') {
                    ++n;
                }
                while (++n < n2 && (c = this.str.charAt(n)) >= '0' && c <= '9') {
                }
            }
            this.value = Float.parse(this.str.substring(this.pos, n), 10);
            this.pos = n;
            return 48;
        }
        this.pos = n + 1;
        return c;
    }

    static {
        builtin.put("sin", new Integer(0));
        builtin.put("cos", new Integer(1));
        builtin.put("tan", new Integer(2));
        builtin.put("asin", new Integer(3));
        builtin.put("acos", new Integer(4));
        builtin.put("atan", new Integer(5));
        builtin.put("exp", new Integer(6));
        builtin.put("sqr", new Integer(13));
        builtin.put("log", new Integer(7));
        builtin.put("ceil", new Integer(9));
        builtin.put("floor", new Integer(10));
    }

    static class PowerExpression
    extends BinaryExpression {
        PowerExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return Float.pow(this.left.evaluate(hashtable), this.right.evaluate(hashtable));
        }
    }

    static class DivExpression
    extends BinaryExpression {
        DivExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.left.evaluate(hashtable).Div(this.right.evaluate(hashtable));
        }
    }

    static class SubExpression
    extends BinaryExpression {
        SubExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.left.evaluate(hashtable).Sub(this.right.evaluate(hashtable));
        }
    }

    static class AddExpression
    extends BinaryExpression {
        AddExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.left.evaluate(hashtable).Add(this.right.evaluate(hashtable));
        }
    }

    static class MulExpression
    extends BinaryExpression {
        MulExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.left.evaluate(hashtable).Mul(this.right.evaluate(hashtable));
        }
    }

    static class RangeExpression
    implements Expression {
        Expression min;
        Expression expr;
        Expression max;

        RangeExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            Float float_ = this.expr.evaluate(hashtable);
            return float_.Great(this.min.evaluate(hashtable)) && float_.Less(this.max.evaluate(hashtable)) ? Float.ONE : Float.ZERO;
        }
    }

    static class GreatExpression
    extends BinaryExpression {
        GreatExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.left.evaluate(hashtable).Great(this.right.evaluate(hashtable)) ? Float.ONE : Float.ZERO;
        }
    }

    static class LessExpression
    extends BinaryExpression {
        LessExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.left.evaluate(hashtable).Less(this.right.evaluate(hashtable)) ? Float.ONE : Float.ZERO;
        }
    }

    static abstract class BinaryExpression
    implements Expression {
        Expression left;
        Expression right;

        BinaryExpression() {
        }

        public abstract /* synthetic */ Float evaluate(Hashtable var1);
    }

    static class BuiltinFunction
    implements Expression {
        Expression operand;
        int kind;

        public Float evaluate(Hashtable hashtable) {
            Float float_ = this.operand.evaluate(hashtable);
            switch (this.kind) {
                case 0: {
                    return Float.sin(float_);
                }
                case 1: {
                    return Float.cos(float_);
                }
                case 2: {
                    return Float.tan(float_);
                }
                case 3: {
                    return Float.asin(float_);
                }
                case 4: {
                    return Float.acos(float_);
                }
                case 5: {
                    return Float.atan(float_);
                }
                case 6: {
                    return Float.exp(float_);
                }
                case 7: {
                    return Float.log(float_);
                }
                case 8: {
                    return Float.abs(float_);
                }
                case 9: {
                    return Float.ceil(float_);
                }
                case 10: {
                    return Float.floor(float_);
                }
                case 13: {
                    return Float.sqrt(float_);
                }
                case 11: {
                    return Float.Int(float_);
                }
                case 12: {
                    return Float.Frac(float_);
                }
            }
            throw new CompileError("Invalid builtin function");
        }

        BuiltinFunction(int n, Expression expression) {
            this.kind = n;
            this.operand = expression;
        }
    }

    static class LiteralExpression
    implements Expression {
        Float value;

        public Float evaluate(Hashtable hashtable) {
            return this.value;
        }

        LiteralExpression(Float float_) {
            this.value = float_;
        }
    }

    static class FunctionCallExpression
    implements Expression {
        String name;
        Expression[] parameters;

        FunctionCallExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            Expression expression = (Expression)hashtable.get(this.name);
            if (expression == null) {
                throw new CompileError("Function '" + this.name + "' is not defined");
            }
            if (!(expression instanceof FunctionExpression)) {
                throw new CompileError("Name '" + this.name + "' is not a function");
            }
            FunctionExpression functionExpression = (FunctionExpression)expression;
            Float[] floatArray = new Float[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                floatArray[i] = this.parameters[i].evaluate(hashtable);
            }
            Float[] floatArray2 = functionExpression.arguments;
            functionExpression.arguments = floatArray;
            Float float_ = functionExpression.evaluate(hashtable);
            functionExpression.arguments = floatArray2;
            return float_;
        }
    }

    static class PlotExpression
    implements Expression {
        Expression from;
        Expression till;
        Expression step;
        String func;
        FunctionExpression f;

        PlotExpression() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Float evaluate(Hashtable hashtable) {
            Expression expression = (Expression)hashtable.get(this.func);
            if (expression == null) {
                Integer n = (Integer)builtin.get(this.func);
                if (n == null) throw new CompileError("Function '" + this.func + "' is not defined");
                this.f = new FunctionExpression();
                this.f.arguments = new Float[1];
                this.f.body = new BuiltinFunction(n, new ParameterExpression(0, this.f));
                return null;
            } else {
                if (!(expression instanceof FunctionExpression)) {
                    throw new CompileError("Last parameter of plot should be function");
                }
                this.f = (FunctionExpression)expression;
                if (this.f.arguments.length == 1) return null;
                throw new CompileError("Last parameter of plot should be function with one argument");
            }
        }
    }

    static class ParameterExpression
    implements Expression {
        FunctionExpression function;
        int index;

        public Float evaluate(Hashtable hashtable) {
            return this.function.arguments[this.index];
        }

        public ParameterExpression(int n, FunctionExpression functionExpression) {
            this.index = n;
            this.function = functionExpression;
        }
    }

    static class FunctionExpression
    implements Expression {
        Float[] arguments;
        Expression body;

        FunctionExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.body.evaluate(hashtable);
        }
    }

    static class VariableExpression
    implements Expression {
        String name;

        public Float evaluate(Hashtable hashtable) {
            Expression expression = (Expression)hashtable.get(this.name);
            if (expression == null) {
                throw new CompileError("Variable '" + this.name + "' is not defined");
            }
            return expression.evaluate(hashtable);
        }

        VariableExpression(String string) {
            this.name = string;
        }
    }

    static class NegExpression
    extends UnaryExpression {
        public Float evaluate(Hashtable hashtable) {
            return this.operand.evaluate(hashtable).Neg();
        }

        NegExpression(Expression expression) {
            this.operand = expression;
        }
    }

    static abstract class UnaryExpression
    implements Expression {
        Expression operand;

        UnaryExpression() {
        }

        public abstract /* synthetic */ Float evaluate(Hashtable var1);
    }

    static class ConditionalExpression
    implements Expression {
        Expression cond;
        Expression ifTrue;
        Expression ifFalse;

        ConditionalExpression() {
        }

        public Float evaluate(Hashtable hashtable) {
            return this.cond.evaluate(hashtable).Equal(Float.ZERO) ? this.ifFalse.evaluate(hashtable) : this.ifTrue.evaluate(hashtable);
        }
    }

    static class FunctionDefExpression
    implements Expression,
    Declaration {
        String name;
        FunctionExpression func;

        FunctionDefExpression() {
        }

        public void declare(Hashtable hashtable) {
            hashtable.put(this.name, this.func);
        }

        public Float evaluate(Hashtable hashtable) {
            this.declare(hashtable);
            return null;
        }
    }

    static class AssignmentExpression
    implements Expression,
    Declaration {
        String name;
        Expression expr;

        AssignmentExpression() {
        }

        public void declare(Hashtable hashtable) {
            hashtable.put(this.name, this.expr);
        }

        public Float evaluate(Hashtable hashtable) {
            this.declare(hashtable);
            return this.expr.evaluate(hashtable);
        }
    }

    static class ExpressionList
    implements Expression {
        Expression[] exprs;

        public Float evaluate(Hashtable hashtable) {
            Float float_ = this.exprs[0].evaluate(hashtable);
            for (int i = 1; i < this.exprs.length; ++i) {
                float_ = this.exprs[i].evaluate(hashtable);
            }
            return float_;
        }

        ExpressionList(Expression[] expressionArray) {
            this.exprs = expressionArray;
        }
    }

    static interface Declaration {
        public void declare(Hashtable var1);
    }

    static interface Expression {
        public Float evaluate(Hashtable var1);
    }
}

