<?php
/*
 * Компонент настроек
 */

class Config extends CComponent
{
    /*
     * Префикс cookies
     */
    const COOKIE_PREFIX = 'fresh_blog_';

    /*
     * Каталог с дизайнами.
     * От корня приложения. С слешем в начале, без него в конце.
     */
    const DESIGN_FOLDER = '/themes';



    /*
     * Объект (CActiveDataProvider) с настройками
     */
    private static $_config;

    /*
     * Были ли изменены настройки в процессе работы скрипта?
     */
    private static $_is_update = FALSE;



    /*
     * Инициализируем компонент
     */
    public function init ()
    {
        self::$_config = UserConfig::model ()->getUserConfig ();
    }

    /*
     * Перегружаем волшебный метод компонента.
     * Теперь к настройкам можно обращаться как к членам класса, что, имхо, очень удобно.
     *
     * !Внимание, возможно нестандартное поведение, ведь это системный метод фреймворка
     */
    public function __get ($key)
    {
        return self::$_config->$key;
    }

    /*
     * Перегружаем волшебный метод компонента.
     *
     * Теперь при установления значения переменной, настройка будет автоматически записываться в базу
     */
    public function __set ($key, $value)
    {
        self::$_is_update = TRUE;
        self::$_config->$key = $value;
    }

    /*
     * Возвращает сформированную строку cols rows (для textarea)
     */
    public static function getColsRows()
    {
        return 'cols="' . (int)self::$_config->textarea_cols . '" rows="' . (int)self::$_config->textarea_rows . '"';
    }

    /*
     * В деструкторе сохраняем настройки в базу (если они были изменены)
     */
    public function __destruct ()
    {
        if (self::$_is_update) self::$_config->save ();
    }
}