<?php

/*
 * Управление категориями
 */

class CategoryController extends Controller
{
	/*
         * Фильтры
         */
        public function filters ()
        {
            return array (
                'accessControl'
            );
        }



        /*
         * Правила доступа
         */
        public function  accessRules ()
        {
            return array (
                array (
                    'allow',
                    'users' => array ('@')
                ),
                array (
                    'allow',
                    'users' => array ('?'),
                    'actions' => array ('view', 'index')
                ),
                array (
                    'deny',
                    'users' => array ('*')
                )
            );
        }



        /**
	 * Просмотр списка статей для данной категории
	 */
	public function actionView($id)
	{
            

            $this->render('view',array(
                'postProvider' => Post::model ()->loadPostsFromCategory ($id),
                'category' => $this->loadModel ($id)
            ));
	}

	/**
	 * Добавление категории
	 */
	public function actionCreate()
	{
		$model = new Category;

                if (isset ($_POST['category']))
		{
                    $model->attributes = $_POST['category'];
                    if ($model->save ())
                        $this->redirect (array('view','id'=>$model->id));
		}

		$this->render ('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Обновление категории
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		if (isset ($_POST['category']))
		{
			$model->attributes = $_POST['category'];
			if ($model->save ())
				$this->redirect (array ('view','id' => $model->id));
		}

		$this->render('update',array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'index' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
            $category = $this->loadModel ($id);

            if ($category->id == Category::ID_NEWS)
            {
                $this->render ('//msg', array ('msg' => 'Эту категорию удалять нельзя!'));
                Yii::app ()->end ();
            }

            if (!isset ($_POST["delete"]))
            {
                $this->render ('delete', array ('category' => $category));
            }
            else
            {
                // Удаляем саму категорию
                $category->delete ();
                // Удаляем все статьи этой категории
                // Если настроены вторичные ключи (а по умолчанию они настроены), СТАТЬИ И КОММЕНТЫ удалятся автоматически
                //Post::model ()->deleteALL ('`id_category`=:id_category', array (':id_category' => $category->id));
                
                $this->redirect (Yii::app ()->request->baseUrl);
            }
	}
        
        /**
         * Просмотр категорий
         */
        public function actionIndex ()
        {
            $this->render ('index', array (
                'categoryProvider' => Category::model ()->loadCategories (),
                'countDrafts' => Post::model ()->getCountDrafts ()
            ));
        }

	

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Category::model()->findByPk((int)$id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}
}
