<?php

/**
 * This is the model class for table "{{user}}".
 *
 * The followings are the available columns in table '{{user}}':
 * @property integer $id
 * @property string $login
 * @property string $pass
 */
class User extends CActiveRecord
{
        /*
         * "Соль" для шифрования пароля.
         * ВНИМАНИЕ!!! НЕ МЕНЯТЬ ПОСЛЕ УСТАНОВКИ СКРИПТА!
         * Иначе скрипт не сможет правильно сравнивать хеши паролей
         */
        protected $salt = 'BuGAga!!! FHTAGN!!!';



        /**
	 * Returns the static model of the specified AR class.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{user}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login', 'required',
                            'message' => 'Вы не ввели логин'),
			array('login', 'length', 'min' => 2, 'max'=>70,
                            'tooShort' => 'Логин должен быть не короче 2 символов', 'tooLong' => 'Логин должен быть не длиннее 70 символов'),

                        array('pass', 'required',
                            'message' => 'Вы не ввели пароль'),
			array('pass', 'length', 'min' => 6,
                            'tooShort' => 'Пароль должен быть не короче 6 символов'),
                        // Создаем хеш пароля
                        array ('pass', 'filter', 'filter' => array ($this, 'hashPassword'))
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			//array('id, login, pass', 'safe', 'on'=>'search'),
		);
	}

	

        /*
         * Шифрование пароля
         */
        public function hashPassword ($string)
        {
            return md5 ($this->salt . md5 ($this->salt . $string . md5 ($this->salt)));
        }

        /*
         * Валидация пароля
         */
        public function validatePassword ($password)
        {
            return $this->hashPassword ($password) === $this->pass;
        }
}