<?php

/**
 * Модель пользовательских настроек.
 * This is the model class for table "{{config}}".
 */
class UserConfig extends CActiveRecord
{

    /*
     * Номер строки в таблице настроек, в которой находятся настройки юзера
     */
    const STRING_USER_CONFIG = 2;

    /*
     * Номер строки со стандартными настройками
     */
    const STRING_STANDART_CONFIG = 1;



    /**
     * Returns the static model of the specified AR class.
     * @return Config the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{config}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        return array(
            array('design, print_about_category, give_in_rss, rss_title, rss_description, rss_item_count, page_count_last_posts, page_count_comments, page_count_categories, tags_cloud_links_count, index_title, index_keywords, index_description, notify_of_new_comments', 'required'),

            array('copyright', 'length', 'max' => 100, 'encoding' => 'utf8'),
            array('print_about_category, notify_of_new_comments, auto_determine_site_version', 'boolean'),
            array('give_in_rss', 'in', 'range' => array('info', 'cut')),
            array('page_count_last_posts, page_count_comments, page_count_categories, tags_cloud_links_count', 'numerical', 'integerOnly' => TRUE, 'min' => 1),

            array('index_title', 'length', 'max' => 200, 'encoding' => 'utf8'),
            array('index_keywords', 'length', 'max' => 500, 'encoding' => 'utf8'),
            array('index_description', 'length', 'max' => 500, 'encoding' => 'utf8'),

            array('title_postfix', 'length', 'max' => 200, 'encoding' => 'utf8'),
            
            array('rss_title', 'length', 'max' => 100, 'encoding' => 'utf8'),
            array('rss_description', 'length', 'max' => 300, 'encoding' => 'utf8'),
            array('rss_item_count', 'numerical', 'integerOnly' => TRUE, 'min' => 10, 'max' => 100),

            array('textarea_cols, textarea_rows', 'numerical', 'integerOnly' => TRUE, 'min' => 2),
        );
    }



    /*
     * Получить личные настройки юзера
     */
    public function getUserConfig ()
    {
        return $this->findByPk (self::STRING_USER_CONFIG);
    }

    /*
     * Получить стандартные настройки
     */
    public function getStandartConfig ()
    {
        return $this->findByPk (self::STRING_STANDART_CONFIG);
    }
}