<?php
    $this->pageTitle = 'Непрочитанные комментарии';
?>
<div class="menu">

<?php if (!count ($commentProvider->getData ())): ?>
    Нет непрочитанных комментариев.
<?php else: ?>

<?php foreach ($commentProvider->getData () as $comment): ?>

<img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/say.png" alt="say" />
#<?php echo (int)$comment->position ?>. <?php if ($comment->login != NULL): ?>
    <b><?php echo CHtml::encode ($comment->login) ?></b>
<?php else: ?>
    <span class="admin"><b><?php echo CHtml::encode ($comment->user->login) ?></b></span>
<?php endif; ?>

(<?php echo CHtml::encode (Yii::app ()->dateFormatter->format ('d MMMM y, HH:mm', $comment->create_time)) ?>)<br />

К статье <a href="<?php echo $this->createUrl ('post/view', array ('id' => $comment->post->id, '#' => 'comment')) ?>"><?php echo CHtml::encode ($comment->post->title) ?></a>.
<hr />

<?php endforeach; ?>
<?php endif; ?>

<?php $this->widget ('Pager', array ('pages' => $commentProvider->pagination)) ?>

</div>