<?php
/* 
 * Просмотр статьи
 */

$this->pageTitle = $post->title;
$this->description = $post->info_content;
$this->keyWords = str_replace (Tag::RAZD, ' ', $post->tags);
$this->printTopTitle = FALSE;
?>
<div class="title">
    <?php echo CHtml::encode ($this->pageTitle);
        // Удаление и изменение статьи. Видит только админ
        $this->renderPartial ('//post/_up_del', array ('post' => $post)); ?>
</div>
<div class="menu">

<?php   // Информация о статье
        $this->renderPartial ('_getPostInfo', array ('post' => $post)) ?>

<hr />

<?php   // Собственно сама статья
        echo nl2br (bbCode::Format (Smile::Format (CHtml::encode ($post->cut_content)))) ?>

</div>

<?php   // Определяем, голосовал ли юзер
        $is_user_vote = (isset (Yii::app ()->request->cookies[Config::COOKIE_PREFIX . 'vote' . $post->id])) ? TRUE : FALSE ?>

<?php if (!$is_user_vote): ?>
<div class="title">Понравилась статья?</div>
<div class="menu">
    <form action="<?php echo $this->createUrl ('//rating/vote', array ('id' => $post->id)) ?>" method="POST">
        <input type="submit" name="rating[yes]" value="Да" /> <input type="submit" name="rating[no]" value="Нет" />
    </form>
</div>
<?php endif; ?>

<div class="title">Информация</div>
<div class="menu">
    Рейтиг статьи: <span class="<?php echo ($post->positive_votes - $post->negative_votes >= 0) ? 'rating_plus' : 'rating_minus' ?>"><?php echo (int)($post->positive_votes - $post->negative_votes) ?></span>.<br />
    Всего просмотров: <b><?php echo (int)$post->all_views ?></b>.<br />
    Уникальных: <b><?php echo (int)$post->unique_views ?></b>.<br />
</div>

<div class="title">Скачать статью</div>
<div class="menu">
    <img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/document.png" alt="document" /> <a href="<?php echo $this->createUrl ('export/txt', array ('id' => $post->id)) ?>">TXT</a>.<br />
    <img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/html.png" alt="html" /> <a href="<?php echo $this->createUrl ('export/html', array ('id' => $post->id)) ?>">HTML</a>.
</div>

<?php   // Комментарии
        $this->renderPartial ('//comment/_viewComments', array (
            'commentProvider' => $commentProvider,
            'id_post' => $post->id
        )) ?>