<?php
/* 
 * Виджет постраничной навигации
 */

class Pager extends CBasePager
{
    /*
     * Объект (CActiveDataProvider::pagination) с информацией для навигации
     */
    public $pages;

    /*
     * Сколько ссылок выводить вокруг тукущей страницы?
     */
    public $aroundLinks = 2;

    /*
     * Сколько ссылок выводить с начала и с конца навигации?
     */
    public $leftRightLinks = 1;

    

    /*
     * Массив с НОМЕРАМИ страниц
     */
    protected $_links = array ();



    public function init ()
    {
        $this->setPages ($this->pages);
        // Создаем 6 пустых элементов
        $this->_links = array (
            'back'          => '',
            'left'          => array (),
            'aroundLeft'    => array (),
                // current
            'aroundRight'   => array (),
            'right'         => array (),
            'forward'       => '',
        );


        
        // Назад
        if ($this->getCurrentPage () != 0)
                $this->_links["back"] = $this->getCurrentPage () - 1;

        // Вперед
        if (($this->getCurrentPage () +1) != $this->getPageCount ())
                $this->_links["forward"] = $this->getCurrentPage () + 1;

        // Ссылки слева
        for ($x = $this->aroundLinks; $x > 0; $x--)
        {
            if (($this->getCurrentPage () - $x) >= 0) $this->_links["aroundLeft"][] = $this->getCurrentPage () - $x;
        }
        
        // Ссылки справа
        for ($x = 1; $x <= $this->aroundLinks; $x++)
        {
            if (($this->getCurrentPage () + $x) < $this->getPageCount ()) $this->_links["aroundRight"][] = $this->getCurrentPage () + $x;
        }

        // Крайние ссылки слева и справа
        for ($x = 0; $x < $this->leftRightLinks; $x++)
        {
            if (($this->getCurrentPage () - $this->aroundLinks) > $x)
                    $this->_links["left"][] = $x;
            
            if (($this->getCurrentPage () + $this->aroundLinks) < ($this->getPageCount () - $this->leftRightLinks + $x))
                    $this->_links["right"][] = $this->getPageCount () - $this->leftRightLinks + $x;
        }



        $this->render ('pager');
    }
}