<?php
/*
 * Настройки
 */

class ConfigController extends Controller
{
    /*
     * Фильтры
     */
    public function filters ()
    {
        return array (
            'accessControl'
        );
    }

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',// Разрешить доступ авторизованным юзерам (то бишь админу)
                'users' => array ('@')
            ),
            array (
                'deny',// Запретить доступ всем остальным юзерам
                'users' => array ('*')
            )
        );
    }



    /*
     * Редактирование настроек
     */
    public function actionIndex ()
    {
        $model = UserConfig::model ()->getUserConfig ();
        // С помощью SPL обходим каталог с дизайнами
        $designArray = new IteratorIterator (new DirectoryIterator (Yii::getPathOfAlias ('webroot') . Config::DESIGN_FOLDER));

        if (isset ($_POST["config"]))
        {
            $model->attributes = $_POST["config"];
            if ($model->save ())
            {
                $this->render ('/msg', array ('msg' => 'Настройки успешно сохранены'));
                Yii::app ()->end ();
            }
        }
        $this->render ('index', array (
            'model' => $model,
            'designArray' => $designArray
        ));
    }

    /*
     * Вернуть стандартные настройки
     */
    public function actionReturnStandartConfigs ()
    {
        if (!isset ($_POST["yes"]))
        {
            $this->render ('return_standart_configs');
        }
        else
        {
            $standart   = UserConfig::model ()->getStandartConfig ();
            $user       = UserConfig::model ()->getUserConfig ();
            
            $user->attributes = $standart->attributes;
            $user->save ();

            $this->render ('//msg', array ('msg' => 'Стандартные настройки успешно возвращены'));
        }
    }
}