<?php
/* 
 * Экспорт статьи в разные форматы
 */

class ExportController extends Controller
{
    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'Txt';

    /*
     * Макет страницы. В данном случае он не нужен
     */
    public $layout = '';



    /*
     * Фильтры
     */
    public function filters ()
    {
        return array (
            'accessControl'
        );
    }

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',// Разрешить доступ всем юзерам
                'users' => array ('*')
            ),
            array (
                'deny',// Запретить доступ всем остальным юзерам
                'users' => array ('*')
            )
        );
    }



    /*
     * Экспорт в txt
     */
    public function actionTxt ($id)
    {
        header ('Content-type: text/txt');

        $this->render ('txt', array (
            'post' => $this->loadModel ($id)
        ));
    }

    /*
     * Экспорт в HTML
     */
    public function actionHtml ($id)
    {
        $this->render ('html', array (
            'post' => $this->loadModel ($id)
        ));
    }



    /*
     * Загрузка модели
     */
    public function loadModel ($id)
    {
        $model = Post::model()->findByPk((int) $id);
        if ($model === null)
            throw new CHttpException(404, 'Этой статьи не существует');
        return $model;
    }
}