<?php
/*
 * Управление файлами статей
 */

class FileController extends Controller
{
    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'add';



    /*
     * Фильтры
     */
    public function filters ()
    {
        return array (
            'accessControl'
        );
    }

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',
                'users' => array ('@')// Доступ только админу
            ),
            array (
                'deny',
                'users' => array ('*')
            )
        );
    }



    /*
     * Добавление файлов
     */
    public function actionAdd ()
    {
        if (!isset ($_POST["count"]) && !isset ($_POST["file"]))
        {
            $this->render ('add_files');
            Yii::app ()->end();
        }
        
        $model = new FileForm;

        if (isset ($_POST["file"]))
        {
            $model->attributes = $_POST["file"];
            $model->upload_file = CUploadedFile::getInstance ($model, 'upload_file');

            if ($model->validate ())
            {
                // Сохраняем файл
                foreach ($model->upload_file as $file)
                {
                    $file->saveAs(Yii::getPathOfAlias('webroot.' . FileForm::PATH));
                }

                $this->render('//msg', array(
                    'msg' => 'Файлы успешно загружены!'
                ));
                Yii::app ()->end();
            }
        }

        $this->render('forms', array(
            'count' => (int) $_POST["count"],
            'model' => $model
        ));
    }

}