<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

require('../incfiles/core.php');
$lng_profile = core::load_lng('profile');

/*
-----------------------------------------------------------------
Закрываем от неавторизованных юзеров
-----------------------------------------------------------------
*/
if (!$user_id) {
    require('../incfiles/head.php');
    echo functions::display_error($lng['access_guest_forbidden']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Получаем данные пользователя
-----------------------------------------------------------------
*/
$user = functions::get_user($user);
if (!$user) {
    require('../incfiles/head.php');
    echo functions::display_error($lng['user_does_not_exist']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Переключаем режимы работы
-----------------------------------------------------------------
*/
$array = array(
    'activity'  => 'includes/profile',
    'ban'       => 'includes/profile',
    'edit'      => 'includes/profile',
    'images'    => 'includes/profile',
    'info'      => 'includes/profile',
    'ip'        => 'includes/profile',
    'guestbook' => 'includes/profile',
    'karma'     => 'includes/profile',
    'office'    => 'includes/profile',
    'password'  => 'includes/profile',
    'reset'     => 'includes/profile',
    'settings'  => 'includes/profile',
    'stat'      => 'includes/profile',
    'friends'   => 'includes/profile'
);
$path = !empty($array[$act]) ? $array[$act] . '/' : '';
if (array_key_exists($act, $array) && file_exists($path . $act . '.php')) {
    require_once($path . $act . '.php');
} else {
    /*
    -----------------------------------------------------------------
    Анкета пользователя
    -----------------------------------------------------------------
    */
    $headmod = 'profile,' . $user['id'];
    $textl = $lng['profile'] . ': ' . htmlspecialchars($user['name']);
    require('../incfiles/head.php');
    echo '<div class="phdr"><b>' . ($user['id'] != $user_id ? $lng_profile['user_profile'] : $lng_profile['my_profile']) . '</b></div>';




    // Меню анкеты
    $menu = array();
    if ($user['id'] == $user_id || $rights == 9 || ($rights == 7 && $rights > $user['rights'])) {
        $menu[] = '<a href="profile.php?act=edit&amp;user=' . $user['id'] . '">' . $lng['edit'] . '</a>';
    }
    if ($user['id'] != $user_id && $rights >= 7 && $rights > $user['rights']) {
        $menu[] = '<a href="' . $set['homeurl'] . '/' . $set['admp'] . '/index.php?act=usr_del&amp;id=' . $user['id'] . '">' . $lng['delete'] . '</a>';
    }
    if ($user['id'] != $user_id && $rights > $user['rights']) {
        $menu[] = '<a href="profile.php?act=ban&amp;mod=do&amp;user=' . $user['id'] . '">' . $lng['ban_do'] . '</a>';
    }
    if (!empty($menu)) {
        echo '<div class="rmenu">' . functions::display_menu($menu) . '</div>';
    }

    //Уведомление о дне рожденья
    if ($user['dayb'] == date('j', time()) && $user['monthb'] == date('n', time())) {
        echo '<div class="gmenu">' . $lng['birthday'] . '!!!</div>';
    }

    // Информация о юзере
    $arg = array(
        'lastvisit' => 1,
        'iphist'    => 1,
        'header'    => '<b>ID:' . $user['id'] . '</b>'
    );

    if ($user['id'] != core::$user_id) {
        $arg['footer'] = '<span class="gray">' . core::$lng['where'] . ':</span> ' . functions::display_place($user['id'], $user['place']);
    }

    echo '<div class="cmenu">';

if (!functions::is_ignor($user['id']) && functions::is_contact($user['id']) != 2 && empty($ban['1']) && empty($ban['3'])) {
            echo '<a href="../mail/index.php?act=write&amp;id=' . $user['id'] . '"><img style="float: right;margin: 0px 0px -30px 10px;" title="' . $lng['write'] . '" src="/images/msg.gif" /></a>';
        }


    echo '' . functions::display_user($user, $arg) . '';

    echo '</div>';
    // Если юзер ожидает подтверждения регистрации, выводим напоминание
    if ($rights >= 7 && !$user['preg'] && empty($user['regadm'])) {
        echo '<div class="rmenu">' . $lng_profile['awaiting_registration'] . '</div>';
    }

    $user_club = mysql_query("SELECT `user_id`, `name`, `city`, `land`, `budj`, `stadion`, `tren` FROM `fman_clubs` WHERE `user_id` = ' .$foydalanuvchi[id]. ' ");
    $result_club = mysql_fetch_assoc($user_club);
    $lastvisit = time() > $user['lastdate'] + 300 ? date("d.m.Y (H:i)", $user['lastdate']) : false;
    echo '
        <div class="smenu">
            Nomi: ' .$result_club['name']. ' <br />
            Shaxri: ' .$result_club['city']. ' <br />
            Millati: ' .$result_club['land']. ' <br />
            Mablag\'i: ' .$result_club['budj']. ' <br />
            Maydoni: ' .$result_club['stadion']. ' <br />
            O\'quv mashg\'ulotlari: ' .$result_club['tren']. ' <br /> <hr />
            ' . ($user['sex'] == 'm' ? $lng_profile['registered_m'] : $lng_profile['registered_w']) . ': ' . date("d.m.Y", $user['datereg']) . '<br />
            ' . ($user['sex'] == 'm' ? $lng_profile['stayed_m'] : $lng_profile['stayed_w']) . ': ' . functions::timecount($user['total_on_site']) . '<br />';
            if ($lastvisit) {echo '' . $lng['last_visit'] . ': ' . $lastvisit . '';} echo '
            <hr />
            ' . $lng['forum'] . ': <a href="profile.php?act=activity&amp;user=' . $user['id'] . '">' . $user['postforum'] . '</a><br />
            ' . $lng['guestbook'] . ': <a href="profile.php?act=activity&amp;mod=comments&amp;user=' . $user['id'] . '">' . $user['postguest'] . '</a><br />
            ' . $lng['comments'] . ': ' . $user['komm'] . '<br />
        </div> 
    ';




    // Меню выбора
$total_photo = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_album_files` WHERE `user_id` = '" . $user['id'] . "'"), 0);
echo '<div class="none"><p>
    <a href="profile.php?act=info&amp;user=' . $user['id'] . '"><div class="menu">' . functions::image('contacts.png') . ' ' . $lng['information'] . '</div></a>
    <a href="profile.php?act=activity&amp;user=' . $user['id'] . '"><div class="menu">' . functions::image('activity.gif') . ' ' . $lng_profile['activity'] . '</div></a>
    <a href="profile.php?act=stat&amp;user=' . $user['id'] . '"><div class="menu">' . functions::image('rate.gif') . ' ' . $lng['statistics'] . '</div></a>';
    $bancount = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_ban_users` WHERE `user_id` = '" . $user['id'] . "'"), 0);

    if ($bancount) {
        echo '<a href="profile.php?act=ban&amp;user=' . $user['id'] . '"><div class="menu"><img src="../images/block.gif" width="16" height="16"/> ' . $lng['infringements'] . ' (' . $bancount . ')</div></a>';
    }

    $total_friends = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_contact` WHERE `user_id`='{$user['id']}' AND `type`='2' AND `friends`='1'"), 0);
    echo '<hrs />' .
        '<a href="album.php?act=list&amp;user=' . $user['id'] . '"><div class="menu">' . functions::image('photo.gif') . ' ' . $lng['photo_album'] . '&#160;(' . $total_photo . ')</div></a>' .
        '<a href="profile.php?act=guestbook&amp;user=' . $user['id'] . '"><div class="menu">' . functions::image('guestbook.gif') . ' ' . $lng['guestbook'] . '&#160;(' . $user['comm_count'] . ')</div></a>' .
        '<a href="profile.php?act=friends&amp;user=' . $user['id'] . '"><div class="menu">' . functions::image('users.png') . ' ' . $lng_profile['friends'] . '&#160;(' . $total_friends . ')</div></a>' .
        '</p></div>';


    if ($user['id'] != $user_id) {
        echo '<div class="smenu"><p>';
        // Контакты
        if (!functions::is_ignor($user['id']) && functions::is_contact($user['id']) != 2) {
            if (!functions::is_friend($user['id'])) {
                $fr_in = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_contact` WHERE `type`='2' AND `from_id`='$user_id' AND `user_id`='{$user['id']}'"), 0);
                $fr_out = mysql_result(mysql_query("SELECT COUNT(*) FROM `cms_contact` WHERE `type`='2' AND `user_id`='$user_id' AND `from_id`='{$user['id']}'"), 0);
                if ($fr_in == 1) {
                    $friend = '<a class="underline" href="profile.php?act=friends&amp;do=ok&amp;id=' . $user['id'] . '"> ' . $lng_profile['confirm_friendship'] . '</a> | <a class="underline" href="profile.php?act=friends&amp;do=no&amp;id=' . $user['id'] . '"> ' . $lng_profile['decline_friendship'] . '</a>';
                } else if ($fr_out == 1) {
                    $friend = '<a class="underline" href="profile.php?act=friends&amp;do=cancel&amp;id=' . $user['id'] . '"> ' . $lng_profile['canceled_demand_friend'] . '</a>';
                } else {
                    $friend = '<a href="profile.php?act=friends&amp;do=add&amp;id=' . $user['id'] . '"> ' . $lng_profile['in_friend'] . '</a>';
                }
            } else {
                $friend = '<a href="profile.php?act=friends&amp;do=delete&amp;id=' . $user['id'] . '"> ' . $lng_profile['remov_friend'] . '</a>';
            }
            echo '<div class="menu">' . functions::image('add.gif') . $friend . '</div>';
        }

        if (functions::is_contact($user['id']) != 2) {
            if (!functions::is_contact($user['id'])) {
                echo '<div class="menu"><img src="../images/users.png" width="16" height="16"/>&#160;<a href="../mail/index.php?id=' . $user['id'] . '">' . $lng_profile['add_contacts'] . '</a></div>';
            } else {
                echo '<div class="menu"><img src="../images/users.png" width="16" height="16"/>&#160;<a href="../mail/index.php?act=deluser&amp;id=' . $user['id'] . '">' . $lng_profile['delete_contacts'] . '</a></div>';
            }
        }

        if (functions::is_contact($user['id']) != 2) {
            echo '<div class="menu"><img src="../images/del.png" width="16" height="16"/>&#160;<a href="../mail/index.php?act=ignor&amp;id=' . $user['id'] . '&amp;add">' . $lng_profile['add_ignor'] . '</a></div>';
        } else {
            echo '<div class="menu"><img src="../images/del.png" width="16" height="16"/>&#160;<a href="../mail/index.php?act=ignor&amp;id=' . $user['id'] . '&amp;del">' . $lng_profile['delete_ignor'] . '</a></div>';
        }
        echo '</p>';
        
        echo '</div>';
    }
    echo '<div class="phdr"><a href="index.php">' . $lng['users'] . '</a></div>';
}

require_once('../incfiles/end.php');