<?php
define('_IN_JOHNCMS', 1);
$textl = 'Beeline UZ yangiliklari';
require_once ('../incfiles/core.php');
require_once ('../incfiles/head.php');

echo'<div class="phdr">Beeline UZ yangiliklari</div>';
$RSSFEEDS = array( 
    0 => "http://mobile.beeline.uz/ru/rss/beelineuz.wbp", 
); 

function FormatRow($title, $description, $link) {
return "
<!-- RSS FEED ENTRY -->
<div class=phdr>$title</div>
<div class=menu>$description</div>
<div class=gmenu><a class=\"feed_link\" href=\"$link\" rel=\"nofollow\" target=\"_blank\">Davomini o'qish...</a></div>
<!-- END OF RSS FEED ENTRY --> 
";
}

// we'll buffer the output
ob_start();

// Now we make sure that we have a feed selected to work with
if (!isset($feedid)) $feedid = 0;
$rss_url = $RSSFEEDS[$feedid];

// Server friendly page cache
$ttl = 0*0;// 60 secs/min for 60 minutes = 1 hour(360 secs)  
$cachefilename = md5($rss_url);
if (file_exists($cachefilename) && (time() - $ttl < filemtime($cachefilename))) {
    // We recently did the work, so we'll save bandwidth by not doing it again
    include($cachefilename); 
    exit();
}

// Now we read the feed
$rss_feed = file_get_contents($rss_url); 

// Now we replace a few things that may cause problems later
$rss_feed = str_replace("<![CDATA[", "", $rss_feed); 
$rss_feed = str_replace("]]>", "", $rss_feed); 
$rss_feed = str_replace("\n", "", $rss_feed); 

// If there is an image node remove it, we aren't going to use 
// it anyway and it often contains a <title> and <link> 
// that we don't want to match on later. 
$rss_feed = preg_replace('#<image>(.*?)</image>#', '', $rss_feed, 1 ); 

// Now we get the nodes that we're interested in
preg_match_all('#<title>(.*?)</title>#', $rss_feed, $title, PREG_SET_ORDER); 
preg_match_all('#<link>(.*?)</link>#', $rss_feed, $link, PREG_SET_ORDER);
preg_match_all('#<description>(.*?)</description>#', $rss_feed, $description, PREG_SET_ORDER); 

// 
// Now that the RSS/XML is parsed.. Lets Make HTML ! 
// 

// If there is not at least one title, then the feed was empty 
// it happens sometimes, so lets be prepared and do something  
// reasonable
if(count($title) <= 1) 
{
    echo "No news at present, please check back later.<br><br>";
} 
else 
{ 
    // OK Here we go, this is the fun part 

    // Well do up the top 3 entries from the feed
    for ($counter = 1; $counter <= 10; $counter++ ) 
    { 
        // We do a reality check to make sure there is something we can show
        if(!empty($title[$counter][1])) 
        { 
            // Then we'll make a good faith effort to make the title 
            // valid HTML 
            $title[$counter][1] = str_replace("&", "&", $title[$counter][1]);
            $title[$counter][1] = str_replace("&apos;", "'", $title[$counter][1]);     

            // The description often has encoded HTML entities in it, and 
            // we probably don't want these, so we'll decode them
            $description[$counter][1] =  html_entity_decode( $description[$counter][1]);     

            // Now we make a pretty page bit from the data we retrieved from 
            // the RSS feed.  Remember the function FormatRow from the  
            // beginning of the program ?  Here we put it to use.
            $row = FormatRow($title[$counter][1],$description[$counter][1],$link[$counter][1]);

            // And now we'll output the new page bit! 
            echo $row;
        }
    }
}
                
// Finally we'll save a copy of the pretty HTML we just created 
// so that we can skip most of the work next time
$fp = fopen($cachefilename, 'w'); 
fwrite($fp, ob_get_contents()); 
fclose($fp); 

// All Finished! 
ob_end_flush();
require_once ("../incfiles/end.php");

?> 