<?php


class game
{
     /** @var integer id загружаемого вопроса*/
    private $loadquestion; 
    
     /** @var integer id текущего шага*/
    private $step; 
    
    /** @var integer id следующего шага*/
    private $nextstep; 
    
    /** @var array массив с данными пользователя */
    private $user; //данные пользователя
    
    /** @var string ИД пользователя (если неавторизован - сессия)*/
    private $userId;
    
    /** @var integer id текущего вопроса*/
    private $questionId;
    
    /** @var integer вариант ответа на текущий вопрос*/
    private $trueanswer;
    
    /** @var integer вариант ответа на следующий вопрос*/
    private $nexttrueanswer;
    
    /** @var array подсказоки */
    private $hint; 
    
    /** @var integer активация подсказки*/
    private $ishint;
    
    /** @var integer время последнего ответа*/
    private $time;
    
    /** @var integer подсказка 50:50*/
    private $hint1;
    
    /** @var integer подсказка звонок другу*/
    private $hint2;
    
    /** @var string подсказка помощь зала */
    private $hint3;
    
    /** @var string подсказка право на ошибку */
    private $hint4;
    
    /** @var integer очки рейтига за игровую сессию*/
    private $points;

    
    /**
     * Конструктор
     *
    */
    public function __construct()
    {
        global $datauser;
        $user = $datauser;

        $this -> user = $user;
            
        $this -> userId = ($user['id'] == false)
                ?$this -> userId = session_id()
                :$this -> userId = $user['id'];
        
        
        //загружаем игровую сессию
        $loadgame = $this ->LoadSession(); 
        
        $print = '';
        $hintactivate = false;
        
        //если нет сессии начинаем новую
        if(!$loadgame)
        {
            $this -> step = 1;
            $this -> nextstep = 2;
            
            $this -> hint = array(1=>0,2=>0,3=>0,4=>0);
                        
            echo $this -> ShowQuest();
            
            $this ->NewSession();
            
            $this-> points = 0;
            $this ->RecRating();
                                            
        }
        else 
        {
            
            $ishint = intval(@$_GET['hint']);
            
            if($ishint > 4 && $ishint < 1)
                $ishint = 0;
    
            
            $hints = array(
                1 => $loadgame['hint'][1],
                2 => $loadgame['hint'][2],
                3 => $loadgame['hint'][3],
                4 => $loadgame['hint'][4]
            );
            
            $this -> hint1 = $loadgame['hintresult'][1];
            $this -> hint2 = $loadgame['hintresult'][2];
            
            $this -> hint3 = array(
                1 => $loadgame['hintresult'][3][0],
                2 => $loadgame['hintresult'][3][1],
                3 => $loadgame['hintresult'][3][2],
                4 => $loadgame['hintresult'][3][3]
            );
            
            $this -> hint4 = $loadgame['hintresult'][4];
            
            $this -> trueanswer = $loadgame['trueanswer'];
            $this -> questionId = $loadgame['loadquestion'];
            $this -> nextstep   = $loadgame['nextstep'];
            $this -> step = $loadgame['nextstep'];
            $this -> time = $loadgame['time'];
            
            if(($hints[$ishint] == 0 && $ishint != 0))
            {
                $hintactivate = true;
                
                $this -> nextstep = $loadgame['nextstep'] - 1;
                $this -> step = $loadgame['nextstep'] - 1;
                
                $hints[$ishint] = $this->step;
            }
            
           
            
            $this -> hint = $hints;
            
            //$loadgame
            
            $this -> PointsCount();
            
            //подсказка 4 право на ошибку
            if(($hints[4] == $this -> step - 1) && intval(@$_GET['answer']) )
            {
                if($this -> trueanswer != intval(@$_GET['answer']) && !$this-> hint4)
                {
                    $this-> hint4 = intval(@$_GET['answer']);
                    
                    $this -> nextstep = $loadgame['nextstep'] - 1;
                    $this -> step = $loadgame['nextstep'] - 1;
                    
                    $hintactivate = true;
                    
                }
            }
            
             $this -> ishint = $hintactivate;
            
            //заканчиваем игру если ответ не правильный
            if($this -> trueanswer != intval(@$_GET['answer']) && !$hintactivate)
            {
                $this ->StopGame();
                              
            }
            else
            {
                
                if($this->step == 16)
                {
                    $this ->ShowWin();
                    
                }
                else
                {
                    if($this -> time < time() -intval(trim(file_get_contents('inc/TimeStep.ts'))))
                    {
                        $this ->StopGameTime();
                        
                    }
                    else
                    {
                        $print = $this ->ShowQuest();

                        $this ->RecSession();

                        echo $print;
                    }
                }
                
            }//else limit time

        }//else loadgame(new game)
     
    }
    
    /**
     * Счётчик баллов
     *
    */
    private function PointsCount()
    {
        $step = $this-> step;
        
        if(!$_GET['stopgame'])
        {
            if($step <= 5)
                $points = 0;
            elseif($step <= 10)
                $points = 16;
            elseif($step <= 15)
                $points = 512;
            else
                $points = 16384;
                  
        }
        else
        {
            $points = pow(2,$step-3);
            
            if($step==2)
                $points = 0;
        }

        $this-> points = $points;
    }
    
    /**
     * Панель подсказок
     *
     * @return string
    */
    private function PrintHints()
    {
        $hint = $this -> hint;
        
        $return = "<div class = 'phdr'>";
        
        $return .= ($hint[1] == 0) 
                ? "<a href = '?hint=1'><b>(50:50)</b></a> "
                : "<b><span style ='text-decoration: line-through'>(50:50)</span></b> ";
        
        $return .= ($hint[2] == 0)
                ? "<a href = '?hint=2'><b>(Звонок другу)</b></a> "
                : "<b><span style ='text-decoration: line-through'>(Звонок другу)</span></b> ";
        
        $return .= ($hint[3] == 0)
                ? "<a href = '?hint=3'><b>(Помощь зала)</b></a> "
                : "<b><span style ='text-decoration: line-through'>(Помощь зала)</span></b> ";
        
        $return .= ($hint[4] == 0)
                ? "<a href = '?hint=4'><b>(Право на ошибку)</b></a>"
                : "<b><span style ='text-decoration: line-through'>(Право на ошибку)</span></b>";
        
        return $return."</div>";
    }
    
    /**
     * Завершение игры при неправильном ответе и добровольно
     *
    */
    private function StopGame()
    {        
        $old = $this ->LoadOldQuest();
        
        echo (@$_GET['stopgame'] == false)
            ? "<div class='phdr'>Вы не правильно ответили на вопрос</div>"
            : "<div class='phdr'>Вы покинули игру</div>";
            
        
        
        echo    '<div class="list1">Правильным ответом на вопрос:<b> "'.$old['quest'].
            '"</b> был выриант ответа'
              . " <b>№ ".$old['true'].': "'.$old[$old['true']]
            .'"</b><p>Баллов заработано: '.$this->points.'</p></div>';
        
        echo  "<div class='list1'>Сыграть <a href = '?'>ещё</a> </div>";
        
        echo "<div class='phdr'><a href = 'index.php'>В начало</a></div>";
        
        $this->DelSession();
        
        $this ->RecRating();
                           
    } 
    
    /**
     * Завершении игру по лимиту времени
     *
    */
    private function StopGameTime()
    {
        
        echo "<div class = 'phdr'>Время истекло</div>".
                     "<div class='list1'>Время, отведённое на ответы истекло. Начните ".
                        "<a href = '?'>игру заново</a> </div>";
        
        echo "<div class='phdr'><a href = 'index.php'>В начало</a></div>";
        
        $this->DelSession();
        
        $this ->RecRating();
    }
    
    /**
     * Победа!!!11
     *
    */
    private function ShowWin()
    {
        echo "<div class='phdr'>Поздравляем!</div>".
                 "<div class='list1'>Вы верно ответили на все вопросы (заработано баллов: ".
                $this->points."). ".
                 "Предлагаем вам <a href = '?'>сыграть</a> ещё раз.</div>";
            
        echo "<div class='phdr'><a href = 'index.php'>В начало</a></div>";
        
        $this->DelSession();
        
        $this ->RecRating();
    }
    
    private function Hint3Maker()
    {
        $hint3 = $this -> hint3;
        
        if($hint3[1]+$hint3[2]+$hint3[3]+$hint3[4] != 0)
        {
            return;
        }
        else
        {
            // перед просмотром кода ниже советую выколоть глаза
            $a1 = $a2 = $a3 = $a4 = 25;
            $a1 = $a1+mt_rand(15, 40);
            $s = $a1+$a2+$a3+$a4;
            $s -= 100;
            $a2 += ($s - $s%3)/3;
            $s = $a1+$a2+$a3+$a4;
            $s -= 100;
            $a1 -= $s;
            $a3 = $a3+mt_rand(1, 20);
            $s = $a1+$a2+$a3+$a4;
            $s -= 100;
            $a4 += ($s - $s%3)/3;
            $s = $a1+$a2+$a3+$a4;
            $s -= 100;
            $a3 -= $s;

            $f[] = $a1;
            $f[] = $a2;
            $f[] = $a3;
            $f[] = $a4;

            rsort($f);

            $ar = array(1 => 1,2,3,4);

            $array = array(1 => 0,0,0,0);

            $array[$this->trueanswer] = $f[0];
            unset($ar[$this->trueanswer]);

            $i = 1;

            $hint = $this -> hint;

            if($this -> hint1 && $hint[1] == $this ->step)
            {
                $array[$this->trueanswer] = 100 - $f[0];
                $array[$this -> hint1]     = $f[0];
                unset($ar[$this -> hint1]);
                $i++;                    
            }
            else
            {
                while(count($ar) != 0)
                {
                    $r = array_rand($ar);

                    $array[$r] = $f[$i];

                    unset($ar[$r]);
                    $i++;
                }

            }

            $this -> hint3 = $array;

        }
    }
    
    /**
     * Вывод результата подсказок
     *
     * @return string
    */
    private function HintResult()
    {
        $hint = $this -> hint;
        
        $text = '';
        
        $q = $this ->LoadOldQuest();
        
        $arr = array(1 => "A","B","C","D");
        
        if($hint[2] == $this->step)
            $text .= "<div class = 'maintxt'>Ваш друг склоняется к варианту ответа ".
                            "<b>".$arr[$q['true']].": ".$q[$q['true']]."</b></div>";

        
        
        if($hint[3] == $this->step)
        {
            $this ->Hint3Maker();
            
            $result = $this->hint3;
            
            $text .="<div class = 'menu'>";
            
            for($i=1;$i<=4;$i++)
            {
                if($hint[1] != $this -> step)
                    $text .="<p><b>".$arr[$i].": ".$result[$i]."%</b></p>";
                else
                {
                    if($i == $q['true'] || $i == $this->hint1)
                        $text .="<p><b>".$arr[$i].": ".$result[$i]."%</b></p>";
                }
            }
            
            $text .='</div>';
        }
        
        
        return $text;
       
      
    }
    
     /**
     * Вывод вопроса
     *
     * @return string
    */
        
    
    private function ShowQuest()
    {        
        $step = $this-> step;
        $hint = $this->hint;
        
        $link = '?answer=';
        
        if(!$this->ishint)
            $q = $this ->LoadNewQuest();
        else
            $q = $this ->LoadOldQuest();
        
        $this -> loadquestion = $q['id'];
        $this -> nexttrueanswer = $q['true'];
        
        //50:50
        if($hint[1] == $step)
        { 
            
            if(!$this->hint1)
            {
                $arr = array(1 => 1,2,3,4);
                
                unset($arr[$q['true']]);

                $rand_key = array_rand($arr);
                
                $this->hint1=$rand_key;
            }
            
            $show = intval(trim($this->hint1));
            
        }
        
        $text =  "<div class='phdr'>Вопрос №$step: <b>".$q['quest'].'</b><br />'.
             "Баллы: ".pow(2,$step-1)."</div>".$this ->PrintHints().$this -> HintResult();
        
        for($i=1;$i<=4;$i++)
        {
            $true = true;
            
            if($hint[1] == $step)
            {
                if($i != $show && $i !=$q['true'])
                    $true = false;
            }
            
            if($hint[4] == $step && $i==$this->hint4)
                $true = false;
            
            $text .= $this ->Answer ($q[$i], $i, $true);
        }
        
     //   $text .= "<p><b> ".$q[$q['true']]."</b></p>"; //develop
                        
        $text .= "<div class='phdr'><a href = '?stopgame=true'>Покинуть игру</a></div>";
        
        return $text;
        
    }
   
    
    /**
     * Показываем вариант ответа
     *
     * @param string $text вариант ответа
     * @param integer $num номер варианта ответа
     * @param boolean $islink показывать как ссылку?
     * @return string
    */
    private function Answer($text,$num,$islink)
    {
        $arr = array(1 => "A","B","C","D");
        
        if($islink)
            return "<div class='menu'><b>".$arr[$num].":</b> <a href = '?answer=".$num."'>".$text."</a></div>";
        else
            return "";
    }
    
    /**
     * Загрузка игровой сессии
     *
     * @return array
     * 
    */    
    private function LoadSession()
    {
        if(file_exists('tmp/'.$this -> userId.'.ini'))
        {
            return parse_ini_file('tmp/'.$this -> userId.'.ini',1);
        }
        
        return false;
    }
    
     /**
     * Запись игровой сессии
     *
     * 
    */
    private function RecSession()
    {
        $hint = $this -> hint;
        
        $hint3 = $this->hint3;
        
        $text = "step = ".$this ->nextstep."\n".
                "nextstep = ".($this ->nextstep + 1)."\n".
                "time = ".time()."\n".
                "loadquestion = ".$this -> loadquestion."\n".
                "trueanswer = ".$this -> nexttrueanswer."\n".
                "username = ".$this ->user['name']."\n".
                "[hint]\n".
                "1 = ".$hint[1]."\n".
                "2 = ".$hint[2]."\n".
                "3 = ".$hint[3]."\n".
                "4 = ".$hint[4]."\n".
                "[hintresult]\n".
                "1 = ".$this->hint1."\n".
                "2 = ".$this->hint2."\n".
                "3[] = ".$hint3[1]."\n".
                "3[] = ".$hint3[2]."\n".
                "3[] = ".$hint3[3]."\n".
                "3[] = ".$hint3[4]."\n".
                "4 = ".$this->hint4."\n";
        
        file_put_contents('tmp/'.$this -> userId.'.ini', $text);
        
    }
    
      private function NewSession()
    {
        
        $text = "step = 1\n".
                "nextstep = 2\n".
                "time = ".time()."\n".
                "loadquestion = ".$this -> loadquestion."\n".
                "trueanswer = ".$this -> nexttrueanswer."\n".
                "username = ".$this ->user['name']."\n".
                "[hint]\n".
                "1 = 0\n".
                "2 = 0\n".
                "3 = 0\n".
                "4 = 0\n".
                "[hintresult]\n".
                "1 = 0\n".
                "2 = 0\n".
                "3[] = 0\n".
                "3[] = 0\n".
                "3[] = 0\n".
                "3[] = 0\n".
                "4 = 0\n";
        
        file_put_contents('tmp/'.$this -> userId.'.ini', $text);
        
    }
        
     /**
     * Удаление игровой сессии
     *
    */
    private function DelSession()
    {
        @unlink('tmp/'.$this -> userId.'.ini');
    }

    
     /**
     * Загрузка предыдущего вопроса
     *
     * @return array
    */
    private function LoadOldQuest()
    {
        $q = mysql_query("SELECT * FROM `game_millioner` WHERE `id` = '".$this ->questionId."';");
        
        $q = mysql_fetch_assoc($q);
        
        
        return $q;
    }
    
    /**
     * Загрузка нового вопроса
     *
     * @return array
    */
     private function LoadNewQuest()
    {
        
        $q = mysql_query("SELECT * FROM `game_millioner` WHERE `step` = '".
                $this->step."' ORDER BY rand();");
        
        $q = @mysql_fetch_assoc($q);
        
        
        return $q;
        
    }
    
    /**
     * Запись игрового рейтинга
     *
    */
    private function RecRating()
    {
        $step = $this -> step;
        $userId = $this -> userId;
        $user = $this -> user;
                        
        if(isset($user['name']))
        {
            $q = mysql_query("SELECT * FROM `game_millioner_rating` WHERE `userid` = '$userId';");
         
            if(mysql_num_rows($q))
            {
               // $q = mysql_fetch_assoc($q);
                $q =      "UPDATE `game_millioner_rating` SET "
                        . "`points` = (`points` + ".$this->points."),"
                        . "`points_week` = (`points_week` + ".$this->points."),"
                        . "`points_day` = (`points_day` + ".$this->points.")"
                        ;
                
                if($step == 16)
                    $q .= ", `winner` = (`winner` + 1)"
                        . ", `winner_week` = (`winner_week` + 1)"
                        . ", `winner_day` = (`winner_day` + 1)";
               
                if($step == 1)
                    $q .= ", `games` = (`games` + 1)"
                        . ", `games_week` = (`games_week` + 1)"
                        . ", `games_day` = (`games_day` + 1)";
                
                mysql_query($q." WHERE `userid` = '".$userId."';") or die(mysql_error());
            }   
            else
            {
                mysql_query("INSERT INTO `game_millioner_rating` SET"
                        . "`username` = '".$user['name']."',"
                        . "`userid` = '".$userId."',"
                        . "`games`  = '1',"
                        . "`games_week` = '1',"
                        . "`games_day` = '1',"
                        . "`winner` = '1',"
                        . "`winner_week` = '1',"
                        . "`winner_day` = '1',"
                        . "`points` = '".$this -> points."',"
                        . "`points_week` = '".$this -> points."',"
                        . "`points_day` = '".$this -> points."';"
                        );
               
            }

        }
        
    }
}

?>